//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls.Private 1.0

FocusScope {
    id : colorPicker

    property color color : "white"

    implicitWidth  : childrenRect.width
    implicitHeight : childrenRect.height

    Component.onCompleted : {
        // Initialize components properly
        colorMapper.updateColor(colorPicker.color);

        hueBox.hue = colorMapper.hue;
        satValueBox.hue = colorMapper.hue;
        hueInput.text   = colorMapper.hue;
        satValueBox.saturation = colorMapper.saturation;
        saturationInput.text = colorMapper.saturation;
        satValueBox.value = colorMapper.value;
        valueInput.text = colorMapper.value;

        redInput.text = colorMapper.red;
        greenInput.text = colorMapper.green;
        blueInput.text = colorMapper.blue;
        alphaInput.text = colorMapper.alpha;

        hexInput.text = colorMapper.hex;
    }
    onColorChanged : colorMapper.updateColor(colorPicker.color)

    ColorMapper {
        id : colorMapper

        onHueChanged : {
            hueBox.hue      = hue;
            satValueBox.hue = hue;
            if (!hueInput.activeFocus) {
                hueInput.text   = hue;
            }
        }
        onSaturationChanged : {
            satValueBox.saturation = colorMapper.saturation;
            if (!saturationInput.activeFocus) {
                saturationInput.text = colorMapper.saturation;
            }
        }
        onValueChanged : {
            satValueBox.value = colorMapper.value;
            if (!valueInput.activeFocus) {
                valueInput.text = colorMapper.value;
            }
        }
        onRedChanged   : {
            if (!redInput.activeFocus) {
                redInput.text = red;
            }
        }
        onGreenChanged : {
            if (!greenInput.activeFocus) {
                greenInput.text = green;
            }
        }
        onBlueChanged  : {
            if (!blueInput.activeFocus) {
                blueInput.text = blue;
            }
        }
        onAlphaChanged : {
            if (!alphaInput.activeFocus) {
                alphaInput.text = alpha;
            }
        }
        onHexChanged : {
            if (!hexInput.activeFocus) {
                hexInput.text = hex;
            }
        }
        onColorChanged : colorPicker.color = color
    }

    SaturationValueBox {
        id : satValueBox

        width  : 255
        height : width

        onSaturationChanged : colorMapper.updateSaturation(saturation)
        onValueChanged      : colorMapper.updateValue(value)

        crossHairDelegate : Item {
            Rectangle {
                height : 8
                width  : 8
                color  : "#66FFFFFF"
                anchors.centerIn : parent
                border {
                    width : 1
                    color : "black"
                }
            }
        }
    }

    HueBox {
        id : hueBox

        width  : satValueBox.width
        height : 16

        onHueChanged : colorMapper.updateHue(hue)

        anchors {
            top : satValueBox.bottom
            topMargin : 10
        }

        sliderDelegate : Item {
            Rectangle {
                height : hueBox.height + 2
                width  : 2
                color  : "black"
                anchors.centerIn : parent
            }
        }
    }

    Column {
        anchors {
            left : satValueBox.right
            top  : satValueBox.top
            leftMargin : 10
        }
        spacing : 2

        Row {
            spacing : 4
            Text { text : "R:" }
            TextInput {
                id : redInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateRed(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.red;
                    }
                }
            }
        }
        Row {
            spacing : 4
            Text { text : "G:" }
            TextInput {
                id : greenInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateGreen(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.green;
                    }
                }
            }
        }
        Row {
            spacing : 4
            Text { text : "B:" }
            TextInput {
                id : blueInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateBlue(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.blue;
                    }
                }
            }
        }
        Row {
            spacing : 4
            Text { text : "A:" }
            TextInput {
                id : alphaInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateAlpha(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.alpha;
                    }
                }
            }
        }
        Row {
            spacing : 4
            Text { text : "H:" }
            TextInput {
                id : hueInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 359
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateHue(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.hue;
                    }
                }
            }
        }

        Row {
            spacing : 4
            Text { text : "S:" }
            TextInput {
                id : saturationInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateSaturation(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.saturation;
                    }
                }
            }
        }
        Row {
            spacing : 4
            Text { text : "V:" }
            TextInput {
                id : valueInput
                width  : 32
                height : 24
                activeFocusOnTab : true
                validator : IntValidator {
                    bottom : 0
                    top    : 255
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateValue(parseInt(text));
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.value;
                    }
                }
            }
        }

        Row {
            Text { text : "#" }
            TextInput {
                id : hexInput
                width  : 64
                height : 24
                activeFocusOnTab : true
                validator : RegExpValidator {
                    regExp : /^([0-9a-f]{3}|[0-9a-f]{6})$/i
                }
                onTextChanged : {
                    if (!acceptableInput)
                        return;
                    colorMapper.updateHex(text);
                }
                onActiveFocusChanged : {
                    if (!activeFocus) {
                        text = colorMapper.hex;
                    }
                }
            }
        }

        CheckerBox {
            width  : 32
            height : 32

            Rectangle {
                width : parent.width
                height : parent.height - 4
                color  : colorPicker.color

            }

            Rectangle {
                width : parent.width
                height : 4
                y : parent.height - 4
                color : Qt.rgba(colorMapper.red / 255,
                                colorMapper.green / 255,
                                colorMapper.blue / 255, 1.0)
            }
        }
    }
}

